<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visualisasi 3D Model</title>
    <link href="https://cdn.jsdelivr.net/npm/cesium@1.131.0/Build/Cesium/Widgets/widgets.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/cesium@1.131.0/Build/Cesium/Cesium.js"></script>
    <style>
    /* ... (Gaya dasar & Logo tidak berubah) ... */
    body { margin: 0; padding: 0; overflow: hidden; font-family: 'Inter', sans-serif; }
    #cesiumContainer { position: absolute; top: 0; left: 0; height: 100%; width: 100%; margin: 0; overflow: hidden; border-radius: 8px; }
    .cesium-credit-logoContainer img { display: none; }
    .cesium-credit-textContainer { display: none; }
    .cesium-credit-expand-link { display: none !important; }
    .cesium-widget-credits { display: none !important; }
    #companyLogo { 
        position: absolute; bottom: 5px; right: 5px; z-index: 102;
        width: 150px; height: auto; background-color: white; 
        padding: 5px; border-radius: 5px; box-shadow: none; 
    }

    /* ... (Gaya Panel Kontrol tidak berubah) ... */
    #controlPanel {
        background-color: rgba(255, 255, 255, 0.9); padding: 15px; border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); display: flex; flex-direction: column;
        gap: 10px; min-width: 280px; max-height: calc(100% - 40px); overflow-y: auto;
    }
    #controlPanel h3 { margin: 0; color: #333; text-align: center; }
    #controlPanel h4 { margin-top: 10px; margin-bottom: 0; color: #555; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    #controlPanel label { display: flex; align-items: center; gap: 8px; font-size: 14px; color: #333; }
    #controlPanel input[type="checkbox"] { transform: scale(1.2); cursor: pointer; }
    #controlPanel hr { border: none; border-top: 1px solid #ddd; margin: 10px 0; }
    #boqButton { padding: 10px 16px; font-size: 14px; font-weight: bold; color: white; background-color: #007bff; border: none; border-radius: 5px; cursor: pointer; transition: background-color 0.3s; text-align: center; }
    #boqButton:hover { background-color: #0056b3; }

    /* ... (Gaya Filter tidak berubah) ... */
    details { border-top: 1px solid #ddd; padding-top: 10px; }
    summary { font-weight: bold; cursor: pointer; padding: 5px; border-radius: 5px; transition: background-color 0.2s; list-style: '▶ '; margin-left: 10px; }
    details[open] > summary { list-style: '▼ '; }
    .filter-options { padding-left: 15px; display: flex; flex-direction: column; gap: 10px; margin-top: 10px; }
    .filter-options details { border: none; padding-top: 0; }
    .filter-options details summary { font-weight: normal; }
    .select-all-label { font-weight: bold; color: #0056b3; }

    #uiContainer {
        position: absolute; top: 20px; left: 20px; z-index: 100;
        display: flex; flex-direction: column; gap: 15px; max-height: calc(100% - 40px);
    }
    
    /* Tampilkan semua label toggle model */
    .model-toggle-label {
        display: flex;
    }
    
    /* Tampilkan Filter & HR, tapi sembunyikan Tombol BOQ */
    #controlPanel details, #controlPanel hr {
        display: block;
    }
    #boqButton {
        display: none;
    }

    /* [MODIFIKASI CSS - SESUAI PERMINTAAN] Sembunyikan filter DPT */
    #dptFilterDetails {
        display: none;
    }


    /* ... (Gaya Info Container & Scrollbar tidak berubah) ... */
    #dptInfoContainer, #itemInfoContainer {
        background-color: rgba(255, 255, 255, 0.9); padding: 15px; border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); display: none;
        gap: 8px; min-width: 280px; max-height: 40vh; overflow-y: auto;
    }
    /* ... (Sisa CSS disembunyikan agar ringkas) ... */
    </style>
</head>
<body>
    <div id="cesiumContainer"></div>
    <img id="companyLogo" src="assets\img\Logo-kecil.png" alt="Logo Perusahaan">

    <div id="uiContainer">
        <div id="controlPanel">
            <h3>Visualisasi 3D Model</h3>
            <h4>Panel Control</h4>
            <label class="model-toggle-label" id="labelPrimary"><input type="checkbox" id="togglePrimary" checked> Dermaga</label>
            <label class="model-toggle-label" id="labelQuaternary"><input type="checkbox" id="toggleQuaternary" checked> Rumah</label>
            <label class="model-toggle-label" id="labelModelD"><input type="checkbox" id="toggleModelD" checked> Asrama</label>
            <label class="model-toggle-label" id="labelModelE"><input type="checkbox" id="toggleModelE" checked> Gardu Induk</label>
        </div>
    </div>

    <script>
    // Cesium Token
    Cesium.Ion.defaultAccessToken = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIyYmMxOTVlNi00NzU2LTRiMzQtODY3Yy1jMDcwNjM0YWMzYjgiLCJpZCI6MzU3MjMzLCJpYXQiOjE3NjI3Nzk4NjN9.3JI5SnCZDwqYe3PI-RC1OOmCU2Rzzt3DvajI9Rv4b54";
    
    // ... (Viewer & Scene setup tidak berubah) ...
    const viewer = new Cesium.Viewer('cesiumContainer', {
        terrainProvider: new Cesium.EllipsoidTerrainProvider(),
        imageryProvider: new Cesium.OpenStreetMapImageryProvider({
        url : 'https://dev.virtualearth.net',
        key : Cesium.Ion.defaultAccessToken,
        mapStyle : Cesium.BingMapsStyle.AERIAL_WITH_LABELS
        }),
            baseLayerPicker: true, geocoder: false, homeButton: false, infoBox: true, 
            navigationHelpButton: true, sceneModePicker: false, timeline: false,
            animation: false, creditDisplay: false
        });
    const scene = viewer.scene;
    
    // Asset IDs
    const PRIMARY_PHOTOGRAMMETRY_ASSET_ID = 4011927;
    const QUATERNARY_MODEL_ASSET_ID = 4057696; // [MODIFIKASI] Aset ini sekarang akan dimuat sebagai 3D Tiles
    const MODEL_D_ASSET_ID = 4057748;
    const MODEL_E_ASSET_ID = 4057803;


    // [MODIFIKASI] Mengubah nama variabel agar sesuai (bukan KML lagi)
    let primaryPhotogrammetryTileset;
    let quaternaryModelTileset; // <-- Diganti dari quaternaryKmlDataSource
    let modelDTileset, modelETileset;
    
    const loadedFilterTilesets = {};

    /**
     * Memuat tileset 3D Cesium Ion (B3DM/GLTF)
     */
    async function loadIonTileset(assetId) {
        try {
            const tileset = await Cesium.Cesium3DTileset.fromIonAssetId(assetId);
            scene.primitives.add(tileset);
            return tileset;
        } catch (error) { 
            console.error(`Error memuat tileset (Asset ID: ${assetId}): ${error}`); 
            return null; 
        }
    }


    async function initializeMapContent() {
        
        // [MODIFIKASI] Memuat 4 model sebagai 3D Tileset
        const loadPromises = [
            loadIonTileset(PRIMARY_PHOTOGRAMMETRY_ASSET_ID),
            loadIonTileset(QUATERNARY_MODEL_ASSET_ID), // <-- Menggunakan loadIonTileset
            loadIonTileset(MODEL_D_ASSET_ID), // <-- Diaktifkan
            loadIonTileset(MODEL_E_ASSET_ID), // <-- Diaktifkan
        ];
        
        const loadedAssets = await Promise.all(loadPromises);
        
        // [MODIFIKASI] Assignment untuk 4 model
        primaryPhotogrammetryTileset = loadedAssets[0]; 
        quaternaryModelTileset = loadedAssets[1]; // <-- Disimpan sebagai Tileset
        modelDTileset = loadedAssets[2]; // <-- Diaktifkan
        modelETileset = loadedAssets[3]; // <-- Diaktifkan

        // Atur posisi awal
        if (primaryPhotogrammetryTileset) {
            viewer.zoomTo(primaryPhotogrammetryTileset);
        } else if (quaternaryModelTileset) { // <-- Diubah
            viewer.zoomTo(quaternaryModelTileset);
        }
        
        // Listener model utama (Tileset)
        document.getElementById('togglePrimary').addEventListener('change', function() { 
            if (primaryPhotogrammetryTileset) primaryPhotogrammetryTileset.show = this.checked; 
        });
        
        // [MODIFIKASI JAVASCRIPT]: Listener model QUATERNARY (sekarang Tileset)
        document.getElementById('toggleQuaternary').addEventListener('change', function() { 
            if (quaternaryModelTileset) quaternaryModelTileset.show = this.checked; 
        });

        // [MODIFIKASI] Event listener untuk Model D diaktifkan
        document.getElementById('toggleModelD').addEventListener('change', function() { 
            if (modelDTileset) modelDTileset.show = this.checked; 
        });

        // [MODIFIKASI] Event listener untuk Model E diaktifkan
        document.getElementById('toggleModelE').addEventListener('change', function() { 
            if (modelETileset) modelETileset.show = this.checked; 
        });


        // --- [Logika Filter (Tidak Berubah)] ---
        // Logika ini tetap memuat model filter (Railing, Paving, DPT, dll.)
        // Walaupun DPT disembunyikan di UI, kodenya tetap aman di sini.
        
        const filterCheckboxes = document.querySelectorAll('.filter-checkbox');
        const assetKeys = Object.keys(ASSET_IDS);

        console.log("Memulai memuat model filter...");
        const filterLoadPromises = assetKeys.map(async (key) => {
            // ... (Logika pemuatan filter tetap sama) ...
            const assetId = ASSET_IDS[key];
            try {
                const tileset = await loadIonTileset(assetId); 
                if (tileset) {
                    tileset.show = false;
                    loadedFilterTilesets[key] = tileset;
                }
            } catch (error) {
                console.error(`Gagal memuat filter ${key} (ID: ${assetId}): ${error}`);
            }
        });

        await Promise.all(filterLoadPromises);
        console.log("Semua model filter berhasil dimuat.");

        filterCheckboxes.forEach(checkbox => {
            const id = checkbox.id.replace('toggle', '');
            const key = id.charAt(0).toLowerCase() + id.slice(1);

            if (loadedFilterTilesets[key]) {
                checkbox.checked = false; 
                checkbox.addEventListener('change', function() {
                    loadedFilterTilesets[key].show = this.checked;
                    // [DIKOMEN] Panggilan fungsi info box (Drive buttons) tidak diaktifkan.
                    // updateItemInfoContainer();
                    // updateDptInfoContainer();
                });
            } else {
                console.warn(`Tidak ditemukan tileset untuk filter: ${key}`);
                checkbox.disabled = true;
            }
        });

        // Logika untuk 'Pilih Semua Tipe DPT' (tetap ada, tidak error)
        const toggleDptAll = document.getElementById('toggleDptAll');
        const dptCheckboxes = document.querySelectorAll('#dptFilterContainer .filter-checkbox');

        toggleDptAll.addEventListener('change', function() {
            const isChecked = this.checked;
            dptCheckboxes.forEach(cb => {
                if (cb.checked !== isChecked) {
                    cb.checked = isChecked;
                    cb.dispatchEvent(new Event('change')); 
                }
            });
        });
        // --- [AKHIR LOGIKA FILTER] ---
    }

    initializeMapContent();
</script>
</body>
</html>